<?

use psphost\Callback;

if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();

global $APPLICATION;

include_once $_SERVER['DOCUMENT_ROOT'] . '/bitrix/modules/sale/payment/psphost/sdk/autoload.php';

\Bitrix\Main\Loader::includeModule('sale');

try {
    $result = ['success' => true];

    $gate = new psphost\Gate(CSalePaySystemAction::GetParamValue('PROJECT_SALT'));
    $callback = $gate->handleCallback(file_get_contents('php://input'));
    $paymentID = $callback->getPaymentId();

    // cut hostname from payment ID (for test env)
    $paymentID = preg_replace('/.*-/', '', $paymentID);

    // find payment by ID
    $payments = \Bitrix\Sale\PaymentCollection::getList([
        'select' => ['ORDER_ID'],
        'filter' => [
            '=ID' => $paymentID,
        ]
    ])->fetchAll();

    // if payment
    if (\count($payments) !== 1) {
        throw new \Exception('Cannot find payment');
    }

    $orderID = (int)$payments[0]['ORDER_ID'];
    $order = \Bitrix\Sale\Order::load($orderID);

    if ($callback->getPaymentStatus() === Callback::SUCCESS_STATUS) {
        $payment = $order->getPaymentCollection()->getItemById($paymentID);
        $payment->setPaid('Y');
        $order->save();
        $result['message'] = 'Payment status changed';
    }
} catch (Exception $e) {
    $result = [
        'success' => false,
        'message' => $e->getMessage(),
    ];
}

// Response
$APPLICATION->RestartBuffer();
header('Content-Type: application/json; charset=' . LANG_CHARSET);
echo json_encode($result);
die();