<?php

namespace psphost;

class Helper
{
    public static $currencies = [
        'AED' => 100,
        'AFN' => 100,
        'ALL' => 100,
        'AMD' => 100,
        'ANG' => 100,
        'AOA' => 100,
        'ARS' => 100,
        'AUD' => 100,
        'AWG' => 100,
        'AZN' => 100,
        'BAM' => 100,
        'BBD' => 100,
        'BDT' => 100,
        'BGN' => 100,
        'BHD' => 1000,
        'BIF' => 1,
        'BMD' => 100,
        'BND' => 100,
        'BOB' => 100,
        'BOV' => 100,
        'BRL' => 100,
        'BSD' => 100,
        'BTN' => 100,
        'BWP' => 100,
        'BYN' => 100,
        'BYR' => 1,
        'BZD' => 100,
        'CAD' => 100,
        'CDF' => 100,
        'CHE' => 100,
        'CHF' => 100,
        'CHW' => 100,
        'CLF' => 10000,
        'CLP' => 1,
        'CNY' => 100,
        'COP' => 100,
        'COU' => 100,
        'CRC' => 100,
        'CUC' => 100,
        'CUP' => 100,
        'CVE' => 1,
        'CZK' => 100,
        'DJF' => 1,
        'DKK' => 100,
        'DOP' => 100,
        'DZD' => 100,
        'EGP' => 100,
        'ERN' => 100,
        'ETB' => 100,
        'EUR' => 100,
        'FJD' => 100,
        'FKP' => 100,
        'GBP' => 100,
        'GEL' => 100,
        'GHS' => 100,
        'GIP' => 100,
        'GMD' => 100,
        'GNF' => 1,
        'GTQ' => 100,
        'GYD' => 100,
        'HKD' => 100,
        'HNL' => 100,
        'HRK' => 100,
        'HTG' => 100,
        'HUF' => 100,
        'IDR' => 100,
        'ILS' => 100,
        'INR' => 100,
        'IQD' => 1000,
        'IRR' => 100,
        'ISK' => 1,
        'JMD' => 100,
        'JOD' => 1000,
        'JPY' => 1,
        'KES' => 100,
        'KGS' => 100,
        'KHR' => 100,
        'KMF' => 1,
        'KPW' => 100,
        'KRW' => 1,
        'KWD' => 1000,
        'KYD' => 100,
        'KZT' => 100,
        'LAK' => 100,
        'LBP' => 100,
        'LKR' => 100,
        'LRD' => 100,
        'LSL' => 100,
        'LYD' => 1000,
        'MAD' => 100,
        'MDL' => 100,
        'MGA' => 10,
        'MKD' => 100,
        'MMK' => 100,
        'MNT' => 100,
        'MOP' => 100,
        'MRO' => 10,
        'MUR' => 100,
        'MVR' => 100,
        'MWK' => 100,
        'MXN' => 100,
        'MXV' => 100,
        'MYR' => 100,
        'MZN' => 100,
        'NAD' => 100,
        'NGN' => 100,
        'NIO' => 100,
        'NOK' => 100,
        'NPR' => 100,
        'NZD' => 100,
        'OMR' => 1000,
        'PAB' => 100,
        'PEN' => 100,
        'PGK' => 100,
        'PHP' => 100,
        'PKR' => 100,
        'PLN' => 100,
        'PYG' => 1,
        'QAR' => 100,
        'RON' => 100,
        'RSD' => 100,
        'RUB' => 100,
        'RWF' => 1,
        'SAR' => 100,
        'SBD' => 100,
        'SCR' => 100,
        'SDG' => 100,
        'SEK' => 100,
        'SGD' => 100,
        'SHP' => 100,
        'SLL' => 100,
        'SOS' => 100,
        'SRD' => 100,
        'SSP' => 100,
        'STD' => 100,
        'SVC' => 100,
        'SYP' => 100,
        'SZL' => 100,
        'THB' => 100,
        'TJS' => 100,
        'TMT' => 100,
        'TND' => 1000,
        'TOP' => 100,
        'TRY' => 100,
        'TTD' => 100,
        'TWD' => 100,
        'TZS' => 100,
        'UAH' => 100,
        'UGX' => 1,
        'USD' => 100,
        'USN' => 100,
        'UYI' => 1,
        'UYU' => 100,
        'UZS' => 100,
        'VEF' => 100,
        'VND' => 1,
        'VUV' => 1,
        'WST' => 100,
        'XAF' => 1,
        'XAG' => 1,
        'XAU' => 1,
        'XBA' => 1,
        'XBB' => 1,
        'XBC' => 1,
        'XBD' => 1,
        'XCD' => 100,
        'XDR' => 1,
        'XOF' => 1,
        'XPD' => 1,
        'XPF' => 1,
        'XPT' => 1,
        'XSU' => 1,
        'XTS' => 1,
        'XUA' => 1,
        'XXX' => 1,
        'YER' => 100,
        'ZAR' => 100,
        'ZMW' => 100,
        'ZWL' => 100,
    ];

    public static function convertToMinor($amount, $code)
    {
        $code = mb_strtoupper($code);

        if (!array_key_exists($code, self::$currencies)) {
            throw new \Exception('Unknown currency');
        }

        return (int) round(self::$currencies[$code] * $amount);
    }
}
