<?php

namespace psphost;

/**
 * Payment page URL Builder
 */
class PaymentPage
{
    /**
     * Base URL for payment
     *
     * @var string
     */
    private $baseUrl = 'https://paymentpage.psphost.com/payment';

    /**
     * Signature Handler
     *
     * @var SignatureHandler $signatureHandler
     */
    private $signatureHandler;

    /**
     * @param SignatureHandler $signatureHandler
     * @param string $baseUrl
     */
    public function __construct(SignatureHandler $signatureHandler, $baseUrl = '')
    {
        $this->signatureHandler = $signatureHandler;

        if ($baseUrl) {
            $this->baseUrl = $baseUrl;
        }

        if ($host = getenv('PAYMENTPAGE_HOST')) {
            $this->baseUrl = str_replace('paymentpage.psphost.com', $host, $this->baseUrl);
        }
    }

    /**
     * Get full URL for payment
     *
     * @param Payment $payment
     *
     * @return string
     */
    public function getUrl(Payment $payment)
    {
        return $this->baseUrl . '?'. http_build_query($payment->getParams()) . '&signature=' .
            urlencode($this->signatureHandler->sign($payment->getParams()));
    }

    /**
     * @param Payment $payment
     *
     * @return array
     */
    public function getArray(Payment $payment)
    {
        return array_merge(
            $payment->getParams(),
            ['signature' => $this->signatureHandler->sign($payment->getParams())]
        );
    }
}