<?php

namespace Psphost\SimplePay\Controller\StartPayment;

use Magento\Checkout\Model\Session;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Controller\Result\JsonFactory;
use Psphost\SimplePay\Signer;


class Index extends Action
{
    /** @var Session */
    protected $checkoutSession;

    /**
     * @var Signer
     */
    protected $signer;

    /**
     * @var Http
     */
    protected $request;

    /**
     * @var JsonFactory
     */
    protected $resultJsonFactory;

    /**
     * @param Context $context
     * @param CreateHostedCheckout $hostedCheckout
     * @param Session $checkoutSession
     */
    public function __construct(
        Context $context,
        Session $checkoutSession
    )
    {
        parent::__construct($context);
        $this->checkoutSession = $checkoutSession;
        $this->signer = new Signer();

        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $this->request = $objectManager->get('\Magento\Framework\App\Request\Http');
        $this->resultJsonFactory = $objectManager->get('\Magento\Framework\Controller\Result\JsonFactory');
    }

    /**
     * Initialize redirect to bank
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        /** @var Order $order */
        $order = $this->checkoutSession->getLastRealOrder();

        $order->setState(\Magento\Sales\Model\Order::STATE_PENDING_PAYMENT, true);
        $order->setStatus(\Magento\Sales\Model\Order::STATE_PENDING_PAYMENT);
        $order->addStatusToHistory($order->getStatus(), 'Order pending payment by psphost');
        $order->save();

        $redirectUrl = $this->signer->getOrderRedirectUrl($order);

        if ($this->request->isAjax()) {
            return $this->resultJsonFactory->create()->setData([
                'success' => true,
                'cardRedirectUrl' => $redirectUrl
            ]);
        }

        /** @var \Magento\Framework\Controller\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $resultRedirect->setUrl($redirectUrl);
        return $resultRedirect;
    }
}