<?php

namespace Psphost\SimplePay\Model;


use Psphost\SimplePay\Common\PspRefundProcessor;
use Psphost\SimplePay\Signer;
use Magento\Directory\Helper\Data as DirectoryHelper;
use Magento\Sales\Model\Order\Creditmemo;
use Magento\Sales\Model\Order\Payment;
use Magento\Store\Model\ScopeInterface;

class Method extends \Magento\Payment\Model\Method\AbstractMethod
{
    const PAYMENT_METHOD_SIMPLEPAY_CODE = 'simplepay';

    /**
     * Payment method code
     *
     * @var string
     */
    protected $_code = self::PAYMENT_METHOD_SIMPLEPAY_CODE;

    /**
     * @var string
     */
    protected $_infoBlockType = 'Psphost\SimplePay\Block\Info\SimplePay';

    /**
     * Availability option
     *
     * @var bool
     */
    protected $_isOffline = false;

    protected $_canCapture = true;

    protected $_canRefund = true;

    protected $_canRefundInvoicePartial = true;

    protected $_canAuthorize = true;

    /**
     * @param \Magento\Payment\Model\InfoInterface $payment
     * @param float $amount
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function refund(\Magento\Payment\Model\InfoInterface $payment, $amount)
    {
        if (!$this->canRefund()) {
            throw new \Magento\Framework\Exception\LocalizedException(__('The refund action is not available.'));
        }
        /** @var Payment $payment */

        $storeScope = ScopeInterface::SCOPE_STORE;

        $isTest = $this->_scopeConfig->getValue(Signer::XML_IS_TEST, $storeScope);
        $projectId = $this->_scopeConfig->getValue(Signer::XML_PROJECT_ID, $storeScope);
        $salt = $this->_scopeConfig->getValue(Signer::XML_SALT, $storeScope);

        $refundProcessor = new PspRefundProcessor(
            $isTest ? Signer::TEST_PROJECT_ID : $projectId,
            $isTest ? Signer::TEST_PROJECT_KEY : $salt,
            $isTest ? Signer::CMS_PREFIX : ''
        );

        /** @var Creditmemo $creditMemo */
        $creditMemo = $payment->getCreditmemo();

        try {
            $pspRefundResult = $refundProcessor->processRefund(
                $payment->getOrder()->getId(),
                $amount,
                $payment->getOrder()->getOrderCurrency()->getCode()
            );
        } catch (\Exception $e) {
            $creditMemo->addComment('Request was not correctly processed by gateway.');
            $creditMemo->setState(Creditmemo::STATE_CANCELED);
            return $this;
        }

        if ($pspRefundResult->getRefundExternalId() === null) {
            $creditMemo->addComment('Request was declined by gateway.');
            $creditMemo->setState(Creditmemo::STATE_CANCELED);
            return $this;
        }

        $creditMemo->setState(Creditmemo::STATE_OPEN);

        $creditMemo->addComment(sprintf(Signer::REFUND_ID_CONTAINING_COMMENT, $pspRefundResult->getRefundExternalId()));

        return $this;
    }
}