﻿<div class="buttons">
    <div class="pull-right">
        <a href="<?php echo $action; ?>" id="button-confirm" class="btn btn-primary">
            <?php echo $button_confirm; ?>
        </a>
    </div>
</div>

<script type="text/javascript">
    function preConfirmation(callback) {
        var is_confirmed = false;
        return (function() {
            if (is_confirmed) {
                callback();
            }
            jQuery.ajax({
                type: 'get',
                url: 'index.php?route=extension/payment/psphost/confirm',
                cache: false,
                beforeSend: function() {
                    $('#button-confirm').attr('disabled', true);
                },
                complete: function() {
                    $('#button-confirm').attr('disabled', false);
                },
                success: function() {
                    is_confirmed = true;
                    callback();
                }
            });
        })();
    }
</script>

<?php if (!$popup_mode) { ?>
    <script>
        jQuery(document).ready(function() {
            jQuery('#button-confirm').on('click', function (e) {
                e.preventDefault();
                preConfirmation(function() {
                    window.location = $('#button-confirm').attr('href');
                });
            });
        });
    </script>
<?php } ?>

<?php
    if ($popup_mode) {
?>

    <script src="https://<?php echo $paymentpage_host; ?>/shared/merchant.js"></script>
    <link rel="stylesheet" href="https://<?php echo $paymentpage_host; ?>/shared/merchant.css" type="text/css" />

    <script>
        jQuery(document).ready(function() {
            var confirmOrderBtn = jQuery('#button-confirm');
            var redirectUrl = confirmOrderBtn.attr('href');

            confirmOrderBtn.on('click', function(e) {
                e.preventDefault();
                preConfirmation(function() {
                    showPopup(redirectUrl);
                });
            });

            function showPopup(url) {
                var link = document.createElement('a');
                link.href = url;
                var params = link.search.replace(/^\?/, '');

                var config = parseParams(params);

                config.onPaymentSuccess = function() {
                    window.location.replace(config.merchant_success_url);
                };

                config.onPaymentFail = function() {
                    window.location.replace(config.merchant_fail_url);
                };

                console.log(config);
                EPayWidget.run(config);
            }

            function parseParams(str) {
                return str.split('&').reduce(function (params, param) {
                    var paramSplit = param.split('=').map(function (value) {
                        return decodeURIComponent(value.replace('+', ' '));
                    });
                    params[paramSplit[0]] = paramSplit[1];
                    return params;
                }, {});
            }
        });
    </script>

<?php
    }
?>