<?php

class ModelExtensionPaymentPsphost extends Model
{
    const
        STATUS_SUCCESS = 'success',
        STATUS_DECLINE = 'decline',
        STATUS_REFUNDED = 'refunded',
        STATUS_REVERSED = 'reversed';

    public function getMethod($address, $total)
    {
        $this->load->language('extension/payment/psphost');

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('payment_psphost_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

        if (!$this->config->get('payment_psphost_geo_zone_id')) {
            $status = true;
        } elseif ($query->num_rows) {
            $status = true;
        } else {
            $status = false;
        }

        $method_data = array();

        if ($status) {
            $method_data = array(
                'code' => 'psphost',
                'title' => $this->config->get('payment_psphost_title'),
                'terms' => $this->config->get('payment_psphost_description'),
                'sort_order' => $this->config->get('payment_psphost_sort_order')
            );
        }

        return $method_data;
    }

    public function resolveStatus($pspStatus)
    {
        switch ($pspStatus) {
            case self::STATUS_SUCCESS:
                return $this->config->get('payment_psphost_success_status');

            case self::STATUS_DECLINE:
                return $this->config->get('payment_psphost_failed_status');

            case self::STATUS_REFUNDED:
                return $this->config->get('payment_psphost_refunded_status');

            case self::STATUS_REVERSED:
                return $this->config->get('payment_psphost_reversed_status');

            default:
                return $this->config->get('payment_psphost_pending_status');
        }
    }
}

?>
