<?php

require_once __DIR__ . DIRECTORY_SEPARATOR . 'psphost' . DIRECTORY_SEPARATOR . 'signer.php';

class psphost
{
    const TEST_PROJECT_ID = 147626;
    const TEST_PROJECT_SECRET_KEY = '';
    var $code, $title, $description, $enabled, $sort_order, $form_action_url, $order_status_processed, $public_title;

    /**
     * psphost constructor.
     */
    function psphost()
    {
        $this->code = 'psphost';
        $this->title = MODULE_PAYMENT_PSPHOST_TEXT_TITLE;
        $this->public_title = MODULE_PAYMENT_PSPHOST_TEXT_PUBLIC_TITLE;
        $this->description = MODULE_PAYMENT_PSPHOST_TEXT_DESCRIPTION;
        $this->sort_order = defined('MODULE_PAYMENT_PSPHOST_SORT_ORDER') ? MODULE_PAYMENT_PSPHOST_SORT_ORDER : 0;
        $this->enabled = defined('MODULE_PAYMENT_PSPHOST_STATUS') && (MODULE_PAYMENT_PSPHOST_STATUS === 'True') ? true : false;
        $this->order_status_processed = defined('MODULE_PAYMENT_PSPHOST_ORDER_STATUS_ID') && ((int)MODULE_PAYMENT_PSPHOST_ORDER_STATUS_ID > 0) ? (int)MODULE_PAYMENT_PSPHOST_ORDER_STATUS_ID : 0;

        $psphost_error = null;
        if (defined('MODULE_PAYMENT_PSPHOST_STATUS')) {
            $errors = [];
            if ($this->isTestMode()) {
                $this->title .= ' [Test mode]';
                $this->public_title .= ' (' . $this->code . '; test mode)';
            } else {
                if (empty(MODULE_PAYMENT_PSPHOST_PROJECT_ID)) {
                    $errors[] = 'Project ID';
                }
                if (empty(MODULE_PAYMENT_PSPHOST_SECRET_KEY)) {
                    $errors[] = 'Secret key';
                }
            }

            if ($this->order_status_processed === 0) {
                $errors[] = 'Order status';
            }

            if (!empty($errors)) {
                $psphost_error = MODULE_PAYMENT_PSPHOST_ERROR . join(', ', $errors);
            }
        }

        if (!empty($psphost_error)) {
            $this->description = '<div class="secWarning">' . $psphost_error . '</div>' . $this->description;
            $this->enabled = false;
        } else {
            $callbackUrl = $this->getBaseUrl();
            $callbackUrl = preg_replace('/admin\/$/', '', $callbackUrl);
            $callbackUrl  .= 'psphost_callback.php';
            $this->description = sprintf('<div>%s (%s): <a href=\'%s\'>%s</a></div><br/>',
                MODULE_PAYMENT_PSPHOST_CALLBACK_URL_TITLE,
                MODULE_PAYMENT_PSPHOST_CALLBACK_URL_DESCRIPTION,
                $callbackUrl,
                $callbackUrl
            ) . $this->description;
        }

        global $order;
        if (is_object($order)) {
            $this->update_status();
        }
    }

    function check() {
        if (!isset($this->_check)) {
            $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_PSPHOST_STATUS'");
            $this->_check = tep_db_num_rows($check_query);
        }
        return $this->_check;
    }

    /**
     * @return bool
     */
    function isTestMode()
    {
        return MODULE_PAYMENT_PSPHOST_TEST_MODE === 'True';
    }

    /**
     * @return bool
     */
    function isPopupMode()
    {
        return MODULE_PAYMENT_PSPHOST_POPUP_MODE === 'True';
    }

    /**
     * @return int
     */
    function getOrderStatusId()
    {
        return $this->order_status_processed;
    }

    /**
     * @return bool
     */
    function isEnabled()
    {
        return $this->enabled;
    }

    // class methods
    function update_status()
    {
        global $order;

        if (($this->enabled == true) && ((int)MODULE_PAYMENT_PSPHOST_ZONE > 0)) {

            if (empty($order->billing['country']['id'])) {
                return;
            }

            $check_flag = false;

            $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_PSPHOST_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");

            while ($check = tep_db_fetch_array($check_query)) {
                if ($check['zone_id'] < 1) {
                    $check_flag = true;
                    break;
                } elseif ($check['zone_id'] == $order->billing['zone_id']) {
                    $check_flag = true;
                    break;
                }
            }

            if ($check_flag == false) {
                $this->enabled = false;
            }
        }
    }

    function javascript_validation()
    {
        return false;
    }

    /**
     * @return array
     */
    function selection()
    {
        return array(
            'id' => $this->code,
            'module' => $this->title
        );
    }

    /**
     * @return bool
     */
    function pre_confirmation_check()
    {
        return false;
    }

    function confirmation()
    {
        $settings = array(
            'popup_mode' => false
        );
        if ($this->isPopupMode()) {
            $host = $this->getSigner()->getPaymentPageHost();
            echo "<script src=\"https://{$host}/shared/merchant.js\"></script>";
            echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"https://{$host}/shared/merchant.css\" />";
            $settings['popup_mode'] = true;

            echo '<script type="text/javascript">';
            echo file_get_contents(__DIR__ . DIRECTORY_SEPARATOR . $this->code . DIRECTORY_SEPARATOR . 'popup.js');
            echo '</script>';
        }
        echo '<script type="text/javascript">';
        echo 'window.PSPHOST_SETTINGS = ' . json_encode($settings);
        echo '</script>';

        return array('title' => $this->title);
    }

    function getBaseUrl()
    {
        if (isset($_SERVER['HTTPS'])) {
            $protocol = ($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http";
        } else {
            $protocol = 'http';
        }
        $path = preg_replace('/[a-z_]+\.php$/i', '', $_SERVER['PHP_SELF']);
        $host = $_SERVER['HTTP_HOST'];
        return $protocol . "://" . $host . $path;
    }

    function process_button()
    {
        return '';
    }

    function before_process()
    {
        return false;
    }

    function get_last_order_id()
    {
        global $customer_id;
        $query = sprintf('select orders_id from %s where customers_id = \'%d\' order by date_purchased desc limit 1', TABLE_ORDERS, (int)$customer_id);
        $orders_query = tep_db_query($query);

        if (!tep_db_num_rows($orders_query)) {
            tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
        }

        $orders = tep_db_fetch_array($orders_query);
        return $orders['orders_id'];
    }

    /**
     * @return Signer
     */
    function getSigner()
    {
        return new Signer(
            MODULE_PAYMENT_PSPHOST_TEST_MODE === 'True',
            MODULE_PAYMENT_PSPHOST_PROJECT_ID,
            MODULE_PAYMENT_PSPHOST_SECRET_KEY,
            MODULE_PAYMENT_PSPHOST_LANGUAGE,
            MODULE_PAYMENT_PSPHOST_ADDITIONAL_PARAMETERS,
            $this->getBaseUrl()
        );
    }

    function after_process()
    {
        global $cart, $order, $currencies, $customer_id;
        $orderId = $this->get_last_order_id();

        $signer = $this->getSigner();

        $currency = $order->info['currency'];
        $total = $currencies->get_value($currency) * $order->info['total'];
        $total = round($total * 100);

        $redirectUrl = $signer->getOrderRedirectUrl($orderId, $total, $customer_id, $currency);

        if ($this->isPopupMode()) {
            header('Content-Type: application/json');
            echo json_encode([
                'success' => true,
                'redirectUrl' => $redirectUrl
            ]);
            exit;
        }

        $cart->reset(true);
        tep_session_unregister('sendto');
        tep_session_unregister('billto');
        tep_session_unregister('shipping');
        tep_session_unregister('payment');
        tep_session_unregister('comments');

        header('Location: ' . $redirectUrl);
        tep_exit();
    }

    function install()
    {
        require_once __DIR__ . DIRECTORY_SEPARATOR . '../../../includes/languages/english/modules/payment/psphost.php';
        $this->_install_checkbox(
            'MODULE_PAYMENT_PSPHOST_STATUS',
            MODULE_PAYMENT_PSPHOST_STATUS_TITLE,
            'True',
            MODULE_PAYMENT_PSPHOST_STATUS_DESCRIPTION, 1);
        $this->_install_checkbox(
            'MODULE_PAYMENT_PSPHOST_TEST_MODE',
            MODULE_PAYMENT_PSPHOST_TEST_MODE_TITLE,
            'True',
            MODULE_PAYMENT_PSPHOST_TEST_MODE_DESCRIPTION, 2);
        $this->_install_checkbox(
            'MODULE_PAYMENT_PSPHOST_POPUP_MODE',
            MODULE_PAYMENT_PSPHOST_POPUP_MODE_TITLE,
            'False',
            MODULE_PAYMENT_PSPHOST_POPUP_MODE_DESCRIPTION, 3);
        $this->_install_text(
            'MODULE_PAYMENT_PSPHOST_PROJECT_ID',
            MODULE_PAYMENT_PSPHOST_PROJECT_ID_TITLE,
            '',
            MODULE_PAYMENT_PSPHOST_PROJECT_ID_DESCRIPTION,
            4
        );
        $this->_install_text(
            'MODULE_PAYMENT_PSPHOST_SECRET_KEY',
            MODULE_PAYMENT_PSPHOST_SECRET_KEY_TITLE,
            '',
            MODULE_PAYMENT_PSPHOST_SECRET_KEY_DESCRIPTION,
            5
        );
        $this->_install_text(
            'MODULE_PAYMENT_PSPHOST_ADDITIONAL_PARAMETERS',
            MODULE_PAYMENT_PSPHOST_ADDITIONAL_PARAMETERS_TITLE,
            '',
            MODULE_PAYMENT_PSPHOST_ADDITIONAL_PARAMETERS_DESCRIPTION,
            6
        );
        $this->_install_text(
            'MODULE_PAYMENT_PSPHOST_SORT_ORDER',
            MODULE_PAYMENT_PSPHOST_SORT_ORDER_TITLE,
            '',
            MODULE_PAYMENT_PSPHOST_SORT_ORDER_DESCRIPTION,
            7
        );
        $this->_install_select(
            'MODULE_PAYMENT_PSPHOST_LANGUAGE',
            MODULE_PAYMENT_PSPHOST_LANGUAGE_TITLE,
            'en',
            MODULE_PAYMENT_PSPHOST_LANGUAGE_DESCRIPTION,
            8,
            array("\'en\'", "\'zh\'")
        );

        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('Set Order Status', 'MODULE_PAYMENT_PSPHOST_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");

        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Payment Zone', 'MODULE_PAYMENT_PSPHOST_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
    }

    /**
     * @param $name
     * @param $title
     * @param $default
     * @param $description
     * @param $sortOrder
     */
    private function _install_checkbox($name, $title, $default, $description, $sortOrder)
    {
        $query = sprintf(
            "insert into %s
                (configuration_title, configuration_key, configuration_value,
                configuration_description, configuration_group_id, sort_order,
                set_function, date_added)
                values ('%s', '%s', '%s', '%s', '6', '%s', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())",
            TABLE_CONFIGURATION, $title, $name, $default, $description, $sortOrder
        );
        tep_db_query($query);
    }

    /**
     * @param $name
     * @param $title
     * @param $default
     * @param $description
     * @param $sortOrder
     */
    private function _install_text($name, $title, $default, $description, $sortOrder)
    {
        $query = sprintf(
            "insert into %s
                (configuration_title, configuration_key, configuration_value,
                configuration_description, configuration_group_id, sort_order,
                date_added)
                values ('%s', '%s', '%s', '%s', '6', '%s', now())",
            TABLE_CONFIGURATION, $title, $name, $default, $description, $sortOrder
        );
        tep_db_query($query);
    }

    /**
     * @param $name
     * @param $title
     * @param $default
     * @param $description
     * @param $sortOrder
     * @param array $options
     */
    private function _install_select($name, $title, $default, $description, $sortOrder, array $options)
    {
        $setFunction = 'tep_cfg_select_option(array(' . join(',', $options) . '),';
        $query = sprintf(
            "insert into %s
                (configuration_title, configuration_key, configuration_value,
                configuration_description, configuration_group_id, sort_order,
                set_function, date_added)
                values ('%s', '%s', '%s', '%s', '6', '%s', '%s', now())",
            TABLE_CONFIGURATION, $title, $name, $default, $description, $sortOrder, $setFunction
        );
        tep_db_query($query);
    }

    function remove()
    {
        tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '",
                $this->keys()) . "')");
    }

    /**
     * @return array
     */
    function keys()
    {
        return array(
            'MODULE_PAYMENT_PSPHOST_PROJECT_ID',
            'MODULE_PAYMENT_PSPHOST_SECRET_KEY',
            'MODULE_PAYMENT_PSPHOST_STATUS',
            'MODULE_PAYMENT_PSPHOST_TEST_MODE',
            'MODULE_PAYMENT_PSPHOST_POPUP_MODE',
            'MODULE_PAYMENT_PSPHOST_ADDITIONAL_PARAMETERS',
            'MODULE_PAYMENT_PSPHOST_LANGUAGE',
            'MODULE_PAYMENT_PSPHOST_ZONE',
            'MODULE_PAYMENT_PSPHOST_ORDER_STATUS_ID',
            'MODULE_PAYMENT_PSPHOST_SORT_ORDER'
        );
    }
}

?>
