"use strict";

jQuery(document).ready(function () {
    var $form = jQuery('form[name=checkout_confirmation]');
    var url = $form.attr('action');

    $form.on('submit', function (e) {
        e.preventDefault();
        e.stopPropagation();

        jQuery.ajax({
            method: 'POST',
            url: url
        }).done(function (response) {
            if (response.success) {
                showPopup(response.redirectUrl);
            } else {
                alert('Failed, please refresh page');
            }
        }).fail(function () {
            alert('Failed, please refresh page');
        });
    });

    function showPopup(url) {
        var link = document.createElement('a');
        link.href = url;
        var params = link.search.replace(/^\?/, '');

        var config = parseParams(params);
        console.log(config);

        config.onPaymentSuccess = function () {
            window.location.replace(config.merchant_success_url);
        };

        config.onPaymentFail = function () {
            window.location.replace(config.merchant_fail_url);
        };

        EPayWidget.run(config);
    }

    function parseParams(str) {
        return str.split('&').reduce(function (params, param) {
            var paramSplit = param.split('=').map(function (value) {
                return decodeURIComponent(value.replace('+', ' '));
            });
            params[paramSplit[0]] = paramSplit[1];
            return params;
        }, {});
    }
});