<?php

require 'includes/application_top.php';
require DIR_WS_CLASSES . 'payment.php';
require DIR_WS_CLASSES . 'order.php';
require __DIR__ . '/includes/languages/english/modules/payment/psphost.php';
require __DIR__ . '/includes/modules/payment/psphost.php';
require __DIR__ . '/psphost_functions.php';
require_once __DIR__ . '/includes/modules/payment/psphost/common/PsphostOrderIdFormatter.php';

$module = new psphost();
if (!$module->isEnabled()) {
    http_response_code(400);
    die('Module not active');
}

$body = file_get_contents('php://input');
$bodyData = json_decode($body, true);
if (is_array($bodyData) && $module->getSigner()->checkSignature($bodyData)) {
    $order_id = $bodyData['payment']['id'];
    $order_id = PsphostOrderIdFormatter::removeOrderPrefix($order_id, Signer::CMS_PREFIX);

    $status = $bodyData['payment']['status'];

    $order = psphost_get_order($order_id);
    if (!$order) {
        http_response_code(400);
        die('Order #' . $order_id . ' not found');
    }

    $order_status_id = $module->getOrderStatusId();
    if ($status === 'success') {
        psphost_confirm_order($order, $order_id, $order_status_id);
        die('Ok');
    }
    die('Fail');
}

die('Invalid signature');