<h2>{l s='PSPHost payments' mod='psphost'}</h2>
<form action="#" method="post" style="clear: both; margin-top: 10px;" class="form-vertical">
<fieldset>
	<legend>{l s='Settings' mod='psphost'}</legend>
    <p>
        Please provide project id and secret key received from PSPHost.
    </p>

    <div class="form-group col-md-6">
        <label for="PSPHOST_PROJECT_ID">{l s='Project ID' mod='psphost'}</label>
        <input type="text" class="form-control" id="PSPHOST_PROJECT_ID" name="PSPHOST_PROJECT_ID" value="{$PSPHOST_PROJECT_ID}" />
        <div class="text-muted">
            {l s='Your project ID you could get from PSPHost helpdesk. Leave it blank if test mode' mod='psphost'}
        </div>
    </div>

    <div class="form-group col-md-6">
        <label for="PSPHOST_SECRET_KEY">{l s='Secret key' mod='psphost'}</label>
        <input type="text" size="33" id="PSPHOST_SECRET_KEY" name="PSPHOST_SECRET_KEY" value="{$PSPHOST_SECRET_KEY}" />
        <div class="text-muted">
            {l s='Secret key which is used to sign payment request. You could get it from PSPHost helpdesk' mod='psphost'}
        </div>
    </div>

    <div class="form-group col-md-6">
        <label for="PSPHOST_TITLE">{l s='Title' mod='psphost'}</label>
        <input type="text" id="PSPHOST_TITLE" name="PSPHOST_TITLE" value="{$PSPHOST_TITLE}" />
    </div>

    <div class="form-group col-md-6">
        <label for="PSPHOST_DESCRIPTION">{l s='Description' mod='psphost'}</label>
        <input type="text" id="PSPHOST_DESCRIPTION" name="PSPHOST_DESCRIPTION" value="{$PSPHOST_DESCRIPTION}" />
    </div>

    <div class="form-group col-md-6">
        <label for="PSPHOST_PAYMENT_PAGE_CURRENCY">{l s='Currency' mod='psphost'}</label>
        <select id="PSPHOST_PAYMENT_PAGE_CURRENCY" name="PSPHOST_PAYMENT_PAGE_CURRENCY">
            {foreach from=$availableCurrencies item=currency}
                {if $PSPHOST_PAYMENT_PAGE_CURRENCY === $currency->iso_code}
                    <option value="{$currency->iso_code}" selected>{$currency->name}</option>
                {else}
                    <option value="{$currency->iso_code}">{$currency->name}</option>
                {/if}
            {/foreach}
        </select>
        <div class="text-muted">
            {l s='Payment currency' mod='psphost'}
        </div>
    </div>

    <div class="form-group col-md-6">
        <label for="PSPHOST_PAYMENT_PAGE_LANGUAGE">{l s='Language' mod='psphost'}</label>
        <select id="PSPHOST_PAYMENT_PAGE_LANGUAGE" name="PSPHOST_PAYMENT_PAGE_LANGUAGE">
            {foreach from=$availableLanguages item=lang}
                {if $PSPHOST_PAYMENT_PAGE_LANGUAGE === $lang['code']}
                    <option value="{$lang['code']}" selected>{$lang['name']}</option>
                {else}
                    <option value="{$lang['code']}" >{$lang['name']}</option>
                {/if}
            {/foreach}
        </select>
        <div class="text-muted">
            {l s='Language of payment page' mod='psphost'}
        </div>
    </div>

    <div class="form-group col-md-6">
        <label for="PSPHOST_IS_TEST">{l s='Test mode' mod='psphost'}</label>
        {if $PSPHOST_IS_TEST}
            <input type="checkbox" id="PSPHOST_IS_TEST" name="PSPHOST_IS_TEST" value="1" checked />
        {else}
            <input type="checkbox" id="PSPHOST_IS_TEST" name="PSPHOST_IS_TEST" value="1" />
        {/if}
    </div>

    <div class="form-group col-md-6">
        <label for="PSPHOST_IS_POPUP">{l s='Popup mode' mod='psphost'}</label>
        {if $PSPHOST_IS_POPUP}
            <input type="checkbox" id="PSPHOST_IS_POPUP" name="PSPHOST_IS_POPUP" value="1" checked />
        {else}
            <input type="checkbox" id="PSPHOST_IS_POPUP" name="PSPHOST_IS_POPUP" value="1" />
        {/if}
        <div class="text-muted">
            {l s='Show payment page in popup instead of redirect' mod='psphost'}
        </div>
    </div>

    <div class="form-group col-md-12">
        <label for="PSPHOST_ADDITIONAL_PARAMETERS">{l s='Additional parameters' mod='psphost'}</label>
        <input type="text" class="form-control" id="PSPHOST_ADDITIONAL_PARAMETERS" name="PSPHOST_ADDITIONAL_PARAMETERS" value="{$PSPHOST_ADDITIONAL_PARAMETERS}" />
        <div class="text-muted">
            {l s='It will be added to redirect link to PSPHost payment page' mod='psphost'}
        </div>
    </div>

    <div class="col-md-6 text-right">
        <input type="submit"
           class="btn btn-default"
           name="psphost_updateSettings" value="{l s='Save Settings' mod='psphost'}" class="button" style="cursor: pointer; display:"/>
    </div>

    <div class="form-group col-md-12">
        {l s='You should provide callback endpoint to PSPHost helpdesk. It is required to get information about payment\'s status' mod='psphost'}:
        <a href="{$callbackUrl}">
            {$callbackUrl}
        </a>
    </div>

</fieldset>
</form>

{if $psVersion < '1.6'}
    <style type="text/css">
        .form-group {
            padding: 18px 0;
            border-bottom: 1px solid lightgrey;
        }
        .form-group .text-muted {
            color: gray;
            text-align: right;
        }
    </style>
{/if}
