jQuery(document).ready(function() {

    function isPsphostPayment() {
        return jQuery("input[name='payment_method']:checked").val() === 'psphost';
    }

    var $checkout_form = jQuery('form.checkout');

    function submit_error(error_message) {
        jQuery('.woocommerce-NoticeGroup-checkout, .woocommerce-error, .woocommerce-message').remove();
        $checkout_form.prepend('<div class="woocommerce-NoticeGroup woocommerce-NoticeGroup-checkout">' + error_message + '</div>');
        $checkout_form.removeClass('processing').unblock();
        $checkout_form.find('.input-text, select, input:checkbox').trigger('validate').blur();
        scroll_to_notices();
        jQuery(document.body).trigger('checkout_error');
    }

    function scroll_to_notices() {
        var scrollElement = jQuery('.woocommerce-NoticeGroup-updateOrderReview, .woocommerce-NoticeGroup-checkout'),
            isSmoothScrollSupported = 'scrollBehavior' in document.documentElement.style;

        if (!scrollElement.length) {
            scrollElement = $checkout_form
        }

        if (scrollElement.length) {
            if (isSmoothScrollSupported) {
                scrollElement[0].scrollIntoView({
                    behavior: 'smooth'
                });
            } else {
                jQuery('html, body').animate({
                    scrollTop: (scrollElement.offset().top - 100)
                }, 1000 );
            }
        }
    }

    // Create order via AJAX in case of "popup" or "iframe" mode
    jQuery('body').on('click', '#place_order', function(e) {
        if (!isPsphostPayment() || PSPHOST.mode === 'redirect') {
            return;
        }

        e.preventDefault();

        var serialized = $checkout_form.serialize();

        var data = {
            'action': 'psphost_process',
            'serialized': serialized
        };

        jQuery.ajax({
            type: 'POST',
            url: PSPHOST.ajax_url,
            data: data,
            dataType: 'json',
            success: function(result) {
                try {
                    if ('success' === result.result) {
                        switch (PSPHOST.mode) {
                            case 'iframe':
                                showIframe(result.redirect); break;
                            case 'popup':
                                showPopup(result.redirect); break;
                            default:
                                throw 'Unknown mode';
                        }
                    } else if ('failure' === result.result) {
                        throw 'Result failure';
                    } else {
                        throw 'Invalid response';
                    }
                } catch( err ) {
                    if (true === result.reload) {
                        window.location.reload();
                        return;
                    }

                    if (true === result.refresh) {
                        jQuery(document.body).trigger('update_checkout');
                    }

                    if (result.messages) {
                        submit_error(result.messages);
                    } else {
                        submit_error('<div class="woocommerce-error">' + wc_checkout_params.i18n_checkout_error + '</div>');
                    }
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                submit_error('<div class="woocommerce-error">' + errorThrown + '</div>');
            }
        });
    });

    function showPopup(url) {
        EPayWidget.run(parseParams(url));
    }

    function showIframe(url) {
        var $wooCommerce = jQuery('.woocommerce');
        jQuery('<div style="max-width: 100%; text-align: center">' + // holder
            '<div class="lds-psphost"><div></div><div></div><div></div></div>' + // loader
            '<div id="psphost_iframe" style="max-width: 100%;"></div>' + // target iframe
            '</div>')
            .insertBefore($wooCommerce);
        $wooCommerce.hide();

        EPayWidget.run(parseParams(url));
    }

    function parseParams(url) {
        var link = document.createElement('a');
        link.href = url;
        var str = link.search.replace(/^\?/, '');

        var config = str.split('&').reduce(function (params, param) {
            var paramSplit = param.split('=').map(function (value) {
                return decodeURIComponent(value.replace('+', ' '));
            });
            params[paramSplit[0]] = paramSplit[1];
            return params;
        }, {});

        config.onLoaded = function() {
            jQuery('.lds-psphost').remove();
        }

        return config;
    }
});