<?
IncludeModuleLangFile(__FILE__);

Class psphost extends CModule
{
    const MODULE_ID = 'psphost';

    var $MODULE_ID = 'psphost';
    var $MODULE_VERSION;
    var $MODULE_VERSION_DATE;
    var $MODULE_NAME;
    var $MODULE_DESCRIPTION;

    function __construct()
    {
        $arModuleVersion = array();
        include __DIR__ . '/version.php';

        if (is_array($arModuleVersion) && array_key_exists('VERSION', $arModuleVersion)) {
            $this->MODULE_VERSION = trim($arModuleVersion['VERSION']);
            $this->MODULE_VERSION_DATE = trim($arModuleVersion['VERSION_DATE']);
        }
        $this->MODULE_NAME = trim(GetMessage('PSPHOST_MODULE_NAME'));
        $this->MODULE_DESCRIPTION = trim(GetMessage('PSPHOST_MODULE_DESC'));
        $this->PARTNER_NAME = trim(GetMessage('PSPHOST_PARTNER_NAME'));
        $this->PARTNER_URI = trim(GetMessage('PSPHOST_PARTNER_URI'));
    }

    function InstallFiles()
    {
        CopyDirFiles(
            $_SERVER['DOCUMENT_ROOT'] . '/bitrix/modules/' . $this->MODULE_ID . '/payment_module',
            $_SERVER['DOCUMENT_ROOT'] . '/bitrix/modules/sale/payment/' . $this->MODULE_ID,
            true,
            true
        );

        return true;
    }

    function UnInstallFiles()
    {
        return DeleteDirFilesEx('bitrix/modules/sale/payment/' . $this->MODULE_ID);
    }

    function DoInstall()
    {
        global $DOCUMENT_ROOT, $APPLICATION;
        $this->InstallFiles();
        RegisterModule($this->MODULE_ID);
        $APPLICATION->IncludeAdminFile(
            GetMessage('PSPHOST_INSTALL_TITLE'),
            $DOCUMENT_ROOT . '/bitrix/modules/' . $this->MODULE_ID . '/install/step.php'
        );
        return true;
    }

    function DoUninstall()
    {
        global $DOCUMENT_ROOT, $APPLICATION;
        $this->UnInstallFiles();
        UnRegisterModule($this->MODULE_ID);
        $APPLICATION->IncludeAdminFile(
            GetMessage('PSPHOST_UNINSTALL_TITLE'),
            $DOCUMENT_ROOT . '/bitrix/modules/' . $this->MODULE_ID . '/install/unstep.php'
        );
        return true;
    }

}
