<?php if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();

global $USER, $MESS;

include_once $_SERVER['DOCUMENT_ROOT'] . '/bitrix/modules/sale/payment/psphost/sdk/autoload.php';

\Bitrix\Main\Loader::includeModule('sale');

$paymentDetails = $GLOBALS['SALE_INPUT_PARAMS']['PAYMENT'];
$userDetails = $GLOBALS['SALE_INPUT_PARAMS']['USER'];
$orderID = (int) $paymentDetails['ORDER_ID'];
$paymentID = $paymentDetails['ID'];
$paymentCurrency = $paymentDetails['CURRENCY'];
$paymentAmount = \psphost\Helper::convertToMinor($paymentDetails['SUM'], $paymentCurrency);

$order = \Bitrix\Sale\Order::load($orderID);
$payment = $order->getPaymentCollection()->getItemById($paymentID);
$projectID = CSalePaySystemAction::GetParamValue('PROJECT_ID');
$language = CSalePaySystemAction::GetParamValue('LANGUAGE', 0)
    ? CSalePaySystemAction::GetParamValue('LANGUAGE')
    : LANGUAGE_ID;

$secretKey = CSalePaySystemAction::GetParamValue('PROJECT_SALT');
$isTestMode = CSalePaySystemAction::GetParamValue('TEST_MODE', 'N') === 'Y';
$isPopupMode = CSalePaySystemAction::GetParamValue('POPUP_MODE', 'N') === 'Y';
$paymentPageHost = getenv('PAYMENTPAGE_HOST') ?: 'paymentpage.psphost.com';

if ($isTestMode) {
    $paymentID = gethostname() . '-' . $paymentID;
    $projectID = 147626;
    $secretKey = '11b1f2370a8306af3b798dc3f38a431f1afb0be37455458321100de9a68be9ce2c15b4a400c951f5cc636da0aa4b3dca4004dd8377b1f5b5fbf64c42e259bdd2';
    $paymentPageHost = 'paymentpage.psphost.com';
}

$handler = new psphost\SignatureHandler($secretKey);
$paymentPage = new psphost\PaymentPage($handler);
$holderID = "psphost-iframe-{$paymentID}";

$ePayment = new \psphost\Payment($projectID, $paymentID);
$ePayment->setPaymentDescription("Order #{$orderID}");
$ePayment->setPaymentCurrency($paymentCurrency);
$ePayment->setPaymentAmount($paymentAmount);
$ePayment->setLanguageCode($language);
$ePayment->setCustomerId($USER->getId());

if (CSalePaySystemAction::GetParamValue('SHOW_METHODS') !== 'Y') {
    $ePayment->setForcePaymentMethod('card');
}

parse_str(CSalePaySystemAction::GetParamValue('ADDITIONAL'), $additional);
if ($additional && \is_array($additional)) {
    $ePayment->setAdditionalParams($additional);
}

if (!$isPopupMode) {
    $ePayment->setTargetElement($holderID);
}

?>


<link rel="stylesheet" href="https://<?= $paymentPageHost ?>/shared/merchant.css" />
<script type="text/javascript" src="https://<?= $paymentPageHost ?>/shared/merchant.js"></script>
<script>var psphostConfig = <?= json_encode($paymentPage->getArray($ePayment)) ?></script>
<? if ($isTestMode) : ?>
    <script>psphostConfig.onLoaded = function() {
          var modalwrap = document.querySelector('.ep-modal-wrap');
          var warning = document.getElementById('psphost-test-warning').cloneNode(true);
          if (modalwrap && modalwrap.firstChild.id !== 'psphost-test-warning') {
            modalwrap.insertBefore(warning, modalwrap.firstChild);
          }
      };
    </script>
<? endif ?>

<div style="min-width: 500px">
    <? if ($isTestMode) : ?>
        <p id="psphost-test-warning"
           style="width: 100%; padding: 10px; font-weight: bold; text-align: center"
        >
            <?= $MESS['PSPHOST_WARNING_TEST_MODE'] ?>
        </p>
    <? endif ?>
    <div id="<?= $holderID ?>" style="width: 100%"></div>
</div>
<script type="text/javascript">
  EPayWidget.run(psphostConfig);
</script>
