<?php

namespace Psphost\SimplePay\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Psphost\SimplePay\Signer;

class ConfigProvider implements ConfigProviderInterface
{
    const XML_IS_TEST = 'payment/simplepay/testmode';
    const XML_IS_POPUP = 'payment/simplepay/popupmode';
    const XML_DESCRIPTION = 'payment/simplepay/description';

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    )
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * {@inheritdoc}
     */
    public function getConfig()
    {
        $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
        $isTest = $this->scopeConfig->getValue(self::XML_IS_TEST, $storeScope);
        $isPopup = $this->scopeConfig->getValue(self::XML_IS_POPUP, $storeScope);
        $description = $this->scopeConfig->getValue(self::XML_DESCRIPTION, $storeScope);
        $paymentPageHost = getenv('PAYMENTPAGE_HOST');
        $paymentPageHost = is_string($paymentPageHost) ? $paymentPageHost : Signer::DEFAULT_HOST;
        return [
            'psphost_settings' => compact('isTest', 'isPopup', 'description', 'paymentPageHost')
        ];
    }
}