define(
    [
        'jquery',
        'Magento_Checkout/js/view/payment/default',
        'mage/url'
    ],
    function (
        $,
        Component,
        urlBuilder
    ) {
        'use strict';

        var isJsLoaded = false;
        var redirectUrl = false;
        var isProcessing = false;

        var timer = setInterval(function(){
            if (window.checkoutConfig.psphost_settings.paymentPageHost != null) {
                var head= document.getElementsByTagName('head')[0];
                var link = document.createElement('link');
                var script= document.createElement('script');
                var paymentPageHost = window.checkoutConfig.psphost_settings.paymentPageHost;

                link.rel = 'stylesheet';
                link.href = '//' + paymentPageHost + '/shared/merchant.css';
                link.type = 'text/css';


                script.type= 'text/javascript';
                script.src= '//' + paymentPageHost + '/shared/merchant.js';
                script.async = true;
                script.onload = function() {
                    isJsLoaded = true;
                };

                head.appendChild(link);
                head.appendChild(script);

                clearInterval(timer);
                return;
            }
            console.log('config not loaded yet');
        }, 10);

        function triggerPopup(url) {

            if (!isJsLoaded) {
                console.log('js is not loaded yet');
                return;
            }

            if (redirectUrl) {
                showPopup(redirectUrl);
                return;
            }

            if (isProcessing) {
                return;
            }

            jQuery.ajax({
                method: 'POST',
                url: url,
                dataType: 'json',
                data: {
                    ajax: true
                },
                success: function(response) {
                    isProcessing = false;
                    if (response.success) {
                        redirectUrl = response.cardRedirectUrl;
                        showPopup(redirectUrl);
                        return;
                    }
                    alert(response.error);
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    isProcessing = false;
                    alert(textStatus);
                }
            })
        }

        function showPopup(url) {
            var link = document.createElement('a');
            link.href = url;
            var params = link.search.replace(/^\?/, '');

            var config = parseParams(params);

            config.onPaymentSuccess = function() {
                window.location.replace(config.merchant_success_url);
            };

            config.onPaymentFail = function() {
                window.location.replace(config.merchant_fail_url);
            };

            console.log(config);
            EPayWidget.run(config);
        }

        function parseParams(str) {
            return str.split('&').reduce(function (params, param) {
                var paramSplit = param.split('=').map(function (value) {
                    return decodeURIComponent(value.replace('+', ' '));
                });
                params[paramSplit[0]] = paramSplit[1];
                return params;
            }, {});
        }


        return Component.extend({
            defaults: {
                template: 'Psphost_SimplePay/payment/simplepay',
                redirectAfterPlaceOrder: false
            },

            afterPlaceOrder: function () {
                var url = urlBuilder.build('psphost/startpayment/index');
                console.log('Redirect after place order:', url);
                var isPopup = parseInt(window.checkoutConfig.psphost_settings.isPopup);

                if (isPopup) {
                    triggerPopup(url);
                    return;
                }

                window.location.replace(url);
            },

            getDescription: function() {
                return window.checkoutConfig.psphost_settings.description;
            }
        });
    }
);