<?php

class ControllerExtensionPaymentPsphost extends Controller
{
    private $error = array();

    public function install()
    {
        $defaultSettings = array(
            'psphost_failed_status' => 10,
            'psphost_success_status' => 15,
            'psphost_pending_status' => 1,
            'psphost_reversed_status' => 12,
            'psphost_refunded_status' => 11,
            'psphost_title' => 'Payment via PSPHost',
            'psphost_description' => 'You will be redirected to PSPHost payment page. All data you enter in that page are secured',
            'psphost_testmode' => 'on',
            'psphost_language' => 'en',
            'psphost_sort_order' => 1,
            'psphost_status' => 1
        );
        $this->load->model('setting/setting');
        $this->model_setting_setting->editSetting('psphost', $defaultSettings);
    }

    private function isVersion23()
    {
        return (float)VERSION >= 2.3;
    }

    public function index()
    {
        $this->load->language('extension/payment/psphost');
        $this->document->setTitle($this->language->get('heading_title'));

        if (($this->request->server['REQUEST_METHOD'] === 'POST') && ($this->validate())) {
            $this->load->model('setting/setting');
            $this->model_setting_setting->editSetting('psphost', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            if ($this->isVersion23()) {
                $this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL'));
            } else {
                $this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
            }
        }

        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_edit'] = $this->language->get('text_edit');

        $options = [
            'projectid', 'secretkey', 'title', 'description', 'additional_parameters',
            'testmode', 'language', 'currency', 'popupmode',
            'failed_status', 'success_status', 'pending_status', 'reversed_status', 'refunded_status',
            'sort_order', 'geo_zone_id',
            'status'
        ];

        $this->load->model('localisation/currency');

        if (empty($this->session->data['currency'])) {
            $this->session->data['currency'] = 'USD';
        }

        $data['psphost_currency'] = 'N/A';
        foreach ($this->model_localisation_currency->getCurrencies() as $result) {
            if ($result['code'] !== $this->session->data['currency']) {
                continue;
            }
            $data['psphost_currency'] = $result['title'];
        }

        foreach ($options as $option) {
            $formValue = 'entry_' . $option;
            $formHelp = 'entry_' . $option . '_help';

            $data[$formValue] = $this->language->get($formValue);
            $data[$formHelp] = $this->language->get($formHelp);

            if ($option === 'currency') continue;

            $postValue = 'psphost_' . $option;

            if (isset($this->request->post[$postValue])) {
                $data[$postValue] = $this->request->post[$postValue];
            } else {
                $data[$postValue] = $this->config->get($postValue);
            }
        }

        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');

        $data['text_all_zones'] = $this->language->get('text_all_zones');
        $data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
        $data['tab_settings'] = $this->language->get('tab_settings');
        $data['tab_order_status'] = $this->language->get('tab_order_status');

        $this->load->model('localisation/geo_zone');
        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        $data['entry_callback_url'] = $this->language->get('entry_callback_url');
        $data['entry_callback_url_help'] = $this->language->get('entry_callback_url_help');

        if ($this->isVersion23()) {
            $url = new Url(HTTP_CATALOG, $this->config->get('config_secure') ? HTTPS_CATALOG : HTTP_CATALOG);
            $data['callback_url'] = $url->link('payment/psphost/callback', '', 'SSL');
        } else {
            $url = $this->config->get('config_secure') ? HTTPS_CATALOG : HTTP_CATALOG;
            $data['callback_url'] = sprintf('%s/index.php?route=%s', $url, 'payment/psphost/callback');
        }

        $data['languages'] = [
            'en' => 'English',
            'zh' => 'Chinese'
        ];

        $data['entry_sort_order'] = $this->language->get('entry_sort_order');

        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        foreach ($this->error as $key => $text) {
            $data['error_' . $key] = $text;
        }

        $data['breadcrumbs'] = array();

        if ($this->isVersion23()) {
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL'),
                'separator' => false
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_payment'),
                'href' => $this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL'),
                'separator' => ' :: '
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/payment/psphost', 'token=' . $this->session->data['token'], 'SSL'),
                'separator' => ' :: '
            );
        } else {
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL'),
                'separator' => false
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_payment'),
                'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'),
                'separator' => ' :: '
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('payment/psphost', 'token=' . $this->session->data['token'], 'SSL'),
                'separator' => ' :: '
            );
        }


        if ($this->isVersion23()) {
            $data['action'] = $this->url->link('extension/payment/psphost', 'token=' . $this->session->data['token'], 'SSL');
            $data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL');
        } else {
            $data['action'] = $this->url->link('payment/psphost', 'token=' . $this->session->data['token'], 'SSL');
            $data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');
        }

        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $data['token'] = $this->session->data['token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/payment/psphost.tpl', $data));
    }

    private function validate()
    {
        $permission = $this->isVersion23() ? 'extension/payment/psphost' : 'payment/psphost';
        if (!$this->user->hasPermission('modify', $permission)) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['psphost_title'])) {
            $this->error['warning_title'] = $this->language->get('warning_title');
        }

        if (empty($this->request->post['psphost_testmode'])) {
            if (empty($this->request->post['psphost_projectid'])) {
                $this->error['warning_projectid'] = $this->language->get('warning_projectid');
            }
            if (empty($this->request->post['psphost_secretkey'])) {
                $this->error['warning_secretkey'] = $this->language->get('warning_secretkey');
            }
        }

        return empty($this->error);
    }
}

?>
