<?php

/**
 * @package Woocommerce Psphost
 * @version 1.2
 */
/*
 Plugin Name: Woocommerce Psphost
 Description: Woocommerce Psphost
 Author: <a href="https://psphost.ru">Psphost</a>
 Version: 1.2
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
add_action('init', function () {
    load_plugin_textdomain(
        'woocommerce-psphost',
        null,
        dirname(plugin_basename(__FILE__)) . DIRECTORY_SEPARATOR . 'language'
    );
    register_post_status('wc-pt-refunded', array(
        'label' => _x('Partially refunded', null, 'woocommerce-psphost'),
        'public' => true,
        'exclude_from_search' => false,
        'show_in_admin_all_list' => true,
        'show_in_admin_status_list' => true,
        'label_count' => _n_noop(
            'Partially refunded <span class="count">(%s)</span>',
            'Partially refunded <span class="count">(%s)</span>',
            'woocommerce-psphost'
        )
    ));
});

add_filter('wc_order_statuses', function ($order_statuses) {
    $order_statuses['wc-pt-refunded'] = _x('Partially refunded', null, 'woocommerce-psphost');
    return $order_statuses;
});

/**
 * Check if WooCommerce is active
 * @see https://docs.woocommerce.com/document/create-a-plugin/
 **/
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    add_action('plugins_loaded', function(){
        require_once(__DIR__ . '/include/gateway.php');
    });

    add_filter('woocommerce_payment_gateways', function(array $methods) {
        $methods[]='WC_Gateway_Psphost';
        return $methods;
    });

    add_action('woocommerce_api_wc_gateway_psphost', function() {
        $gateway = new WC_Gateway_Psphost();
        if (!empty($_GET['test'])) {
            $gateway->process_success($_GET['order_id']);
        } else {
            $body = file_get_contents('php://input');
            $bodyData = json_decode($body, true);
            if (is_array($bodyData)) {
                $status = isset($bodyData['payment']['status']) ? $bodyData['payment']['status'] : null;
                if (in_array($status, ['success', 'decline'])) {
                    $gateway->process_callback($bodyData);
                }
                $gateway->process_refund_callback($bodyData);
            } else {
                http_response_code(400);
                die('Invalid request body');
            }
        }
    });

    // register hooks for AJAX requests on checkout
    add_action('wp_ajax_psphost_process', 'psphost_process_ajax');
    add_action('wp_ajax_nopriv_psphost_process', 'psphost_process_ajax');

    // Place order via AJAX
    function psphost_process_ajax() {
        if (isset($_POST['serialized'])) {
            parse_str($_POST['serialized'], $postData);
            foreach ($postData as $key => $value) {
                $_POST[$key] = $value;
            }
            if (!isset($_REQUEST['woocommerce-process-checkout-nonce'])) {
                $_REQUEST['woocommerce-process-checkout-nonce'] = wc_get_var(
                    $postData['woocommerce-process-checkout-nonce']
                );
            }
        }
        WC_Checkout::instance()->process_checkout();
    }

    function psphost_add_checkout_js_css() {
        $host = WC_Gateway_Psphost::getPaymentPageHost();
        wp_enqueue_script('psphost_merchant_js', sprintf('https://%s/shared/merchant.js', $host), [], null);
        wp_enqueue_style('psphost_merchant_css', sprintf('https://%s/shared/merchant.css', $host), [], null);

        $script_handle = 'psphost_checkout_script';
        $plugin_path = '/wp-content/plugins/psphost';
        $gateway = new WC_Gateway_Psphost();

        wp_enqueue_script($script_handle, $plugin_path . '/js/checkout.js', 'jquery');
        wp_localize_script($script_handle, 'PSPHOST', [
            'ajax_url' => admin_url("admin-ajax.php"),
            'mode' => $gateway->get_option('mode')
        ]);

        wp_enqueue_style('psphost_loader_css', $plugin_path . '/css/loader.css');
    }

    add_action('woocommerce_before_checkout_billing_form', 'psphost_add_checkout_js_css');

    add_action('woocommerce_refund_created', array('WC_Gateway_Psphost', 'process_just_saved_refund'), 10, 2);

    add_action('woocommerce_create_refund', 'process_just_created_refund', 10, 2);
}

/**
 * @param WC_Order_Refund $refund
 * @param array $args
 * @throws Exception
 */
function process_just_created_refund($refund, $args)
{
    $gateway = new WC_Gateway_Psphost();
    $gateway->process_just_created_refund($refund, $args);
}
